/**
 *  Copyright © 2023-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 */
package net.javacomm.window.manager;

import java.util.EventObject;
import net.javacomm.multilingual.schema.ISO639;



@SuppressWarnings("serial")
public class WindowSchemaEvent extends EventObject {

  private String filename;
  private ISO639 code;

  /**
   * Ein Schemafenster wird geöffnet.
   *
   * @param source
   *               hat das Ereignis ausgelöst
   */
  public WindowSchemaEvent(Object source) {
    super(source);
  }



  public WindowSchemaEvent(Object source, ISO639 code, String filename) {
    super(source);
    this.code = code;
    this.filename = filename;
  }



  /**
   * Der Dateiname wird mit dem Ereignis verknüpft.
   *
   * @param filename
   *                 ein Dateiname
   */
  public void setFilename(String filename) {
    this.filename = filename;
  }



  /**
   * Gib den Dateiname zurück.
   *
   * @return ein Dateiname
   */
  public String getFilename() {
    return filename;
  }



  /**
   * Gib den Sprachcode zurück.
   *
   * @return Sprachcode nach ISO-639
   */
  public ISO639 getCode() {
    return code;
  }



  /**
   * Der Sprachcode für die GUI-Komponente
   *
   * @param code
   *             Sprachcode nach ISO-639
   */
  public void setCode(ISO639 code) {
    this.code = code;
  }

}
