package net.javacomm.transfer;

import static org.junit.jupiter.api.Assertions.assertEquals;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;



public class TestTransferConfig {

  TransferConfig config;

  @BeforeEach
  public void setUp() {
    config = new TransferConfig();
  }



  @Test
  public void toJson() {
    config.setDomain("chat4j.de");
    config.setIsPublic(true);
    config.setMailSmtpHost("host");
    config.setMailSmtpUser("user");
    config.setHours(24);
    config.setAccount(180);

    String result = config.toString();

    assertEquals(
        "{\"domain\":\"chat4j.de\",\"isPublic\":true,\"mailSmtpUser\":\"user\",\"mailSmtpHost\":\"host\",\"flipToForum\":150,\"hours\":24,\"account\":180}",
        result
    );
  }



  @Test
  public void isPublic_fehlt() {
    config.setDomain("chat4j.de");
    config.setMailSmtpHost("host");
    config.setMailSmtpUser("user");
    config.setHours(24);
    config.setAccount(180);

    String result = config.toString();

    assertEquals(
        "{\"domain\":\"chat4j.de\",\"isPublic\":false,\"mailSmtpUser\":\"user\",\"mailSmtpHost\":\"host\",\"flipToForum\":150,\"hours\":24,\"account\":180}",
        result
    );
  }

}
