package net.javacomm.transfer;

import static org.junit.jupiter.api.Assertions.assertEquals;
import com.google.gson.Gson;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public class TestFiletransferConfig {

  TransferFiletransferConfig config;
  Gson gson;

  @BeforeEach
  public void setUp() {
    config = new TransferFiletransferConfig();
    gson = new Gson();
  }



  @Test
  public void serialize() {
    config.setPort(29467);
    config.setStarttype(Starttype.MANUAL_DE);
    config.setUid("12345678");
    String result = config.toString();
    assertEquals("{\"uid\":\"12345678\",\"port\":29467,\"starttype\":\"MANUAL_DE\"}", result);
  }



  @Test
  @DisplayName(value = "TestFiletransferConfig deserialize")
  public void deserialize() {
    String encoded = "{\"uid\":\"12345678\",\"port\":29467,\"starttype\":\"MANUAL_DE\"}";
    TransferFiletransferConfig result = gson.fromJson(encoded, TransferFiletransferConfig.class);
    assertEquals("12345678", result.getUid());
    assertEquals(29467, result.getPort());
    assertEquals(Starttype.MANUAL_DE, result.getStarttype());
    assertEquals(1, result.getStarttype().getModus(), "modus");
  }



  @Test
  @DisplayName(value = "Gutfall serialize Download und Upload")
  public void serializeDownload() {
    config.setPort(29467);
    config.setStarttype(Starttype.MANUAL_DE);
    config.setUid("12345678");
    config.setDownloadDir("/home/download");
    config.setUploadDir("/home/upload");
    String result = config.toString();
    assertEquals(
        "{\"uid\":\"12345678\",\"port\":29467,\"starttype\":\"MANUAL_DE\",\"downloadDir\":\"/home/download\",\"uploadDir\":\"/home/upload\"}",
        result
    );
  }



  @Test
  @DisplayName(value = "Gutfall deserialize Download und Upload")
  public void deserializeDownload() {
    String encoded = "{\"uid\":\"12345678\",\"port\":29467,\"starttype\":\"MANUAL_DE\",\"downloadDir\":\"/home/download\",\"uploadDir\":\"/home/upload\"}";
    TransferFiletransferConfig result = gson.fromJson(encoded, TransferFiletransferConfig.class);
    assertEquals("12345678", result.getUid());
    assertEquals(29467, result.getPort());
    assertEquals(Starttype.MANUAL_DE, result.getStarttype());
    assertEquals(1, result.getStarttype().getModus(), "modus");
    assertEquals("/home/download", result.getDownloadDir(), "download");
    assertEquals("/home/upload", result.getUploadDir(), "upload");
  }

}
