/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.share;

public abstract class Constants {
  public final static String VERSION = "260206-PRE5";
  public final static int MIN_PORT_RANGE = 29467;
  public final static int MAX_PORT_RANGE = 29478;
  public final static String HTTPS = "https://";
  public final static String HTTP = "http://";
  public final static String WS = "ws://";
  public final static String WSS = "wss://";
  public final static int LEN_NICKNAME = 24;
  public final static int LEN_KONFERENZNAME = 30;
  public final static int LEN_KONFERENZ_BESCHREIBUNG = 255;

  /**
   * Passwort muss diese Mindestlänge haben.
   */
  public final static int MIN_LEN_PASSWORD = 3;

  // über HISTORY_MESSAGES werden 250 Nachrichten geholt
  public final static int HISTORY_MESSAGES = 250;
  public final static int MAX_FILESIZE = 300 * 1024 * 1024;
  /**
   * This domain hosts the server.
   */
  public final static String DOMAIN = "chat4j.de";

  /**
   * Download URL for the JavaComm Windows client.
   */
  public static final String DOWNLOAD_WINPORTABLE = "https://downloads.sourceforge.net/project/javacomm/portable-win64.zip";

  /**
   * Download URL for the JavaComm Linux client.
   */
  public final static String DOWNLOAD_LINPORTABLE = "https://downloads.sourceforge.net/project/javacomm/portable-linux.zip";

  /**
   * Eine Nachricht wird fühestens nach 24 Stunden gelöscht.
   */
  public final static int MIN_DURATION_TIME = 24; // Stunden im Chatmodul
  /**
   * Eine Nachricht wird spätestens nach 720 Stunden gelöscht.
   */
  public final static int MAX_DURATION_TIME = 720; // Stunden im Chatmodul
  /**
   * Mindestanzahl Tage, bevor ein Konto wegen Inaktivität gelöscht wird
   */
  public final static int MIN_ACCOUNT_TIME = 180;
  public final static String IPTV = "http://javacomm.net/javacomm/jaxrs/iptvsender/read/senderliste";
  /**
   * Das Standardübertragungsprotokoll zwischen Client und Server.
   */
  public final static String PROTOCOL = HTTPS;
  public final static String WEBSOCKET = WSS;

}
