/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

import com.google.gson.Gson;



public class Userdata {

  private String nickname;
  private Integer backgroundColor;
  private Integer foregroundColor;
  private String neuesPassword;
  private String confirmationKey;
  private Integer volume;
  private boolean oncall;
  private String session;
  private String email;
  private String password;
  private String userid;

  public Userdata() {}



  public Integer getBackgroundColor() {
    return backgroundColor;
  }



  public String getConfirmationKey() {
    return confirmationKey;
  }



  public final String getEmail() {
    return email;
  }



  public Integer getForegroundColor() {
    return foregroundColor;
  }



  public String getNeuesPassword() {
    return neuesPassword;
  }



  public String getNickname() {
    return nickname;
  }



  public final String getPassword() {
    return password;
  }



  public String getUserid() {
    return userid;
  }



  public Integer getVolume() {
    return volume;
  }



  public boolean isOncall() {
    return oncall;
  }



  public void setBackgroundColor(Integer backgroundColor) {
    this.backgroundColor = backgroundColor;
  }



  public void setConfirmationKey(String confirmationKey) {
    this.confirmationKey = confirmationKey;
  }



  public void setForegroundColor(Integer foregroundColor) {
    this.foregroundColor = foregroundColor;
  }



  public final void setMail(String eMail) {
    this.email = eMail;
  }



  public void setNeuesPassword(String neuesPassword) {
    this.neuesPassword = neuesPassword;
  }



  public void setNickname(String nickname) {
    this.nickname = nickname;
  }



  public void setOncall(boolean oncall) {
    this.oncall = oncall;
  }



  public final void setPassword(String password) {
    this.password = password;
  }



  public void setUserid(String userid) {
    this.userid = userid;
  }



  public void setVolume(Integer volume) {
    this.volume = volume;
  }



  public String getSession() {
    return session;
  }



  public void setSession(String session) {
    this.session = session;
  }



  public String toString() {
    Gson gson = new Gson();
    return gson.toJson(this);
  }

}
