/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;



public class SearchFilesDeserializer implements JsonDeserializer<SEARCHFILES> {

  @Override
  public SEARCHFILES deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context)
      throws JsonParseException {

    JsonObject jsonobject = json.getAsJsonObject();
    HEADER header = HEADER.toHeader(jsonobject.getAsJsonPrimitive(Protocol.HEADER).getAsString());
    JsonObject dataset = jsonobject.getAsJsonObject(Protocol.DATASET);
    String userid = null;
    try {
      userid = dataset.get(SEARCHFILES.USERID).getAsString();
    }
    catch (NullPointerException e) {}
    Boolean start = Boolean.TRUE;
    try {
      start = dataset.get(SEARCHFILES.START).getAsBoolean();
    }
    catch (NullPointerException e) {}

    JsonArray jsonArray = dataset.getAsJsonArray(SEARCHFILES.SEARCHFILE);
    Searchfile[] searchfile = new Searchfile[jsonArray.size()];
    int count = searchfile.length;
    for (int index = 0; index < count; index++) {
      JsonObject readObject = jsonArray.get(index).getAsJsonObject();
      searchfile[index] = new Searchfile();
      searchfile[index].setFilename(readObject.getAsJsonPrimitive(Searchfile.FILENAME).getAsString());
      searchfile[index].setIndex(readObject.getAsJsonPrimitive(Searchfile.INDEX).getAsInt());
      searchfile[index].setFilesize(readObject.getAsJsonPrimitive(Searchfile.FILESIZE).getAsLong());
    }

    SEARCHFILES searchfiles = new SEARCHFILES();
    searchfiles.setCommand(Command.SEARCHFILES);
    searchfiles.setHeader(header);
    searchfiles.setDataset(Protocol.DATASET);
    searchfiles.setUserid(userid);
    searchfiles.setStarted(start);
    searchfiles.setSearchfiles(searchfile);
    return searchfiles;
  }

}
