/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

/**
 * Forum, Besprechungsraum, Pausenraum oder Gruppenraum.
 */
public enum Roomtype {

  FORUM(1),
  BESPRECHUNGSRAUM(2),
  PAUSENRAUM(3),
  GRUPPENRAUM(4);

  private int roomtype;

  private Roomtype(int value) {
    roomtype = value;
  }



  public int getRoomtype() {
    return roomtype;
  }



  public static Roomtype toRoomtype(int value) {
    for (Roomtype tmp : Roomtype.values()) {
      if (tmp.getRoomtype() == value) {
        return tmp;
      }
    }
    throw new IllegalArgumentException();
  }

}
