/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;



public class KonferenzraumUserSerializer implements JsonSerializer<KonferenzraumUser> {

  public KonferenzraumUserSerializer() {}



  @Override
  public JsonElement serialize(KonferenzraumUser konferenzuser, Type type, JsonSerializationContext context) {

    JsonObject jsonObject = new JsonObject();

    jsonObject.add(KonferenzraumUser.ANWESEND, context.serialize(konferenzuser.isAnwesend()));
    jsonObject.add(KonferenzraumUser.SESSION, context.serialize(konferenzuser.getSession()));
    jsonObject.add(KonferenzraumUser.MUTE, context.serialize(konferenzuser.isMute()));
    jsonObject.add(KonferenzraumUser.BACKGROUND_COLOR, context.serialize(konferenzuser.getBackgroundColor()));
    jsonObject.add(KonferenzraumUser.FOREGROUND_COLOR, context.serialize(konferenzuser.getForegroundColor()));
    jsonObject.add(KonferenzraumUser.USERID, context.serialize(konferenzuser.getUserid()));
    jsonObject.add(KonferenzraumUser.NICKNAME, context.serialize(konferenzuser.getNickname()));

    return jsonObject;

  }

}
