/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

/**
 * Wird periodisch an den Client gesendet, um zu prüfen, ob der Client noch
 * vorhanden ist.
 * 
 * 
 * @author llange
 *
 */
public class KEEPALIVE extends MESSAGE {

  
  public final static String SESSIONID = "SESSIONID";
  
  
  private String sessionId;
  
  
  /**
   * Die SessionID ist eindeutig und bezieht sich auf einen Websocket.
   * @param value
   */
  public void setSessionId(String value) {
    sessionId = value;
  }
  

  /**
   * 
   * @return die SessionId
   */
  public String getSessionId() {
    return sessionId;
  }



  @Override
  public String toString() {
    GsonBuilder builder = new GsonBuilder();
    Gson gson = builder.registerTypeAdapter(KEEPALIVE.class, new KeepaliveSerializer()).create();
    return gson.toJson(this);
  }
  
}
