/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;



public class IMAGE extends MESSAGE {

  public final static String SENDERUID = "SENDERUID";
  public final static String SENDERNICKNAME = "SENDERNICKNAME";
  public final static String RECEIVERNICKNAME = "RECEIVERNICKNAME";
  public final static String RECEIVERUID = "RECEIVERUID";
  public final static String RECEIVER_SESSION = "RECEIVER_SESSION";

  private String senderUid;
  private String senderNickname;
  private String receiverNickname;
  private String receiverUid; // wird nur in der RESPONSE gesendet
  private String receiverSession; // wird nur in der RESPONSE gesendet

  public String getReceiverNickname() {
    return receiverNickname;
  }



  /**
   * REQUEST : nicht vorhanden<br>
   * RESPONSE : <b>zwingend</b>
   * 
   * @return an diesen Empfänger wird gesendet
   */
  public String getReceiverSession() {
    return receiverSession;
  }



  public String getReceiverUid() {
    return receiverUid;
  }



  public String getSenderNickname() {
    return senderNickname;
  }



  public String getSenderUid() {
    return senderUid;
  }



  public void setReceiverNickname(String receiverNickname) {
    this.receiverNickname = receiverNickname;
  }



  public void setReceiverSession(String receiverSession) {
    this.receiverSession = receiverSession;
  }



  public void setReceiverUid(String receiverUid) {
    this.receiverUid = receiverUid;
  }



  public void setSenderNickname(String senderNickname) {
    this.senderNickname = senderNickname;
  }



  public void setSenderUid(String senderUid) {
    this.senderUid = senderUid;
  }



  @Override
  public String toString() {
    GsonBuilder builder = new GsonBuilder();
    builder.registerTypeAdapter(IMAGE.class, new ImageSerializer());
    Gson gson = builder.create();
    return gson.toJson(this);
  }

}
