/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;



/**
 * Der 1:1 Chat oder PrivateChat wird durch CALLPRIVATECHAT eingeleitet.
 *
 * @author llange
 *
 */
public class CALLPRIVATECHAT extends MESSAGE {

  public final static String SENDER_UID = "SENDER_UID";
  public final static String RECIPIENT_UID = "RECIPIENT_UID";
  public final static String LOCAL_NICKNAME = "LOCAL_NICKNAME";
  public final static String REMOTE_NICKNAME = "REMOTE_NICKNAME";
  public final static String LOCAL_SESSIONID = "LOCAL_SESSIONID";
  public final static String REMOTE_SESSIONID = "REMOTE_SESSIONID";

  private String sender_uid;
  private String recipient_uid;
  private String local_nickname;
  private String remote_nickname;
  private String localSessionid;
  private String remoteSessionid;

  /**
   * 
   */
  public String getLocalNickname() {
    return local_nickname;
  }



  public String getLocalSessionid() {
    return localSessionid;
  }



  /**
   * 
   * @return UserID
   */
  public String getRecipientUID() {
    return recipient_uid;
  }



  /**
   * 
   */
  public String getRemoteNickname() {
    return remote_nickname;
  }



  public String getRemoteSessionid() {
    return remoteSessionid;
  }



  public String getSenderUID() {
    return sender_uid;
  }



  /**
   * @param value
   */
  public void setLocalNickname(String value) {
    local_nickname = value;
  }



  public void setLocalSessionid(String value) {
    localSessionid = value;
  }



  public void setRecipientUID(String value) {
    recipient_uid = value;
  }



  /**
   * @param value
   */
  public void setRemoteNickname(String value) {
    remote_nickname = value;
  }



  public void setRemoteSessionid(String value) {
    remoteSessionid = value;
  }



  public void setSenderUID(String value) {
    sender_uid = value;
  }



  @Override
  public String toString() {
    GsonBuilder builder = new GsonBuilder();
    builder.registerTypeAdapter(CALLPRIVATECHAT.class, new CallPrivateChatSerializer());
    Gson gson = builder.create();
    return gson.toJson(this);
  }

}
