/*
 * The MIT License
 * Copyright © 2025 Luis Andrés Lange <https://javacomm.net>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.nexuswob.gui.swing;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JTree;



@SuppressWarnings("serial")
public class JGradientTree extends JTree {

  private Color color1;
  private Color color2;

  public JGradientTree() {
    this(Color.WHITE, Color.BLACK);
  }



  public JGradientTree(Color color1, Color color2) {
    setBackgroundGradient(color1, color2);
  }



  public void setBackgroundGradient(Color color1, Color color2) {
    this.color1 = color1;
    this.color2 = color2;
  }



  @Override
  protected void paintComponent(Graphics g) {
    // Erstelle ein Graphics2D-Objekt
    Graphics2D g2d = (Graphics2D) g;

    // Erstelle den Gradient
    GradientPaint gradientPaint = new GradientPaint(0, 0, color1, 0, getHeight(), color2);
    g2d.setPaint(gradientPaint);

    // Fülle den Hintergrund mit dem Gradient
    g2d.fillRect(0, 0, getWidth(), getHeight());

    // Rufe die paintComponent-Methode der Oberklasse auf, um den Baum zu zeichnen
    super.paintComponent(g);
  }
}
