/**
 * The MIT License
 * Copyright © 2020 Luis Andrés Lange <http://javacomm.net>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.nexuswob.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.RenderingHints;
import javax.swing.border.AbstractBorder;

/**
 * Malt einen Rahmen um eine GUI-Komponente.
 * 
 * @author lromero
 *
 */
public class JToolTipBorder extends AbstractBorder {
  private static final long serialVersionUID = 6047072656383921692L;
  
  
  private int gap;
  private int margin_left;
  private int margin_right;
  private int margin_bottom;
  private int margin_top; 
  private Color borderColor;
  private Color insideColor;
  private int thickness;

  
  /**
   * Der ToolTip bekommt einen Rahmen.
   * Die Umrandungslinie ist standardm��ig schwarz mit einem Abstand von 12 Pixel zum Container.
   * 
   */
  public JToolTipBorder() {
    this(12, Color.BLACK, Color.WHITE);
  }
  
  
  
  /**
   * Der ToolTip bekommt einen Rahmen.
   * 
   * @param value der Abstand zwischen Umrandungslinie und Container
   * @param borderColor die Farbe der Umrandungslinie
   * @param insideColor die Farbe zwischen Schriftzug und Umrandung
   */
  public JToolTipBorder(int value, Color borderColor, Color insideColor) {
    this(value, borderColor, insideColor, 2);
  }
  
  
  public JToolTipBorder(int value, Color borderColor, Color insideColor, int thickness) {
    this.thickness = thickness;
    this.gap = value + 6; // 12 ist der interne Abstand zwischen JLabel-Schriftzug und Rahmen
    this.borderColor = borderColor;
    this.insideColor = insideColor;
    margin_left = value;
    margin_right = value;
    margin_bottom = value;
    margin_top = value;
  }
  
  
//  private void paintComplex(Graphics2D g2d, int width, int height) {
//    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
//    GeneralPath polygon = new GeneralPath();
//    polygon.moveTo(margin_left, height-margin_bottom);
//    polygon.lineTo(width-margin_right, height-margin_bottom);
//    polygon.lineTo(width-margin_right, margin_top);
//    int bubble_startpoint_x = margin_left + 12;
//    int bubble_endpoint = bubble_startpoint_x + 12;
//    polygon.lineTo(bubble_endpoint, margin_top);
//    polygon.quadTo((bubble_startpoint_x + bubble_endpoint)/2, 0, bubble_startpoint_x, margin_top);
//    polygon.lineTo(margin_left, margin_top);
//    polygon.closePath();
//    g2d.setStroke(new BasicStroke(2));
//    g2d.setColor(Color.WHITE);
//    g2d.fill(polygon);
//    g2d.setColor(Color.BLACK);
//    g2d.draw(polygon);
//  }
  

  
  public void simplePolygon(Graphics2D g2d, int width, int height) {
    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    Polygon polygon = new Polygon();
    polygon.addPoint(margin_left, height-margin_bottom);
    polygon.addPoint(width-margin_right, height-margin_bottom);
    polygon.addPoint(width-margin_right, margin_top);
    
    polygon.addPoint(33, margin_top);
    polygon.addPoint(28, margin_top-6);
    polygon.addPoint(23, margin_top);
    polygon.addPoint(margin_left, margin_top);
    g2d.setColor(insideColor);
    g2d.fillPolygon(polygon);
    g2d.setColor(borderColor);
    g2d.setStroke(new BasicStroke(thickness));
    g2d.drawPolygon(polygon);
  }

  
  
  
  /**
   * Draw a String centered in the middle of a Rectangle.
   *
   * @param g The Graphics instance.
   * @param text The String to draw.
   * @param rect The Rectangle to center the text in.
   */
//  public void drawCenteredString(Graphics g, String text, Rectangle rect, Font font) {
//      // Get the FontMetrics
//      FontMetrics metrics = g.getFontMetrics(font);
//      // Determine the X coordinate for the text
//      int x = rect.x + (rect.width - metrics.stringWidth(text)) / 2;
//      // Determine the Y coordinate for the text (note we add the ascent, as in java 2d 0 is top of the screen)
//      int y = rect.y + ((rect.height - metrics.getHeight()) / 2) + metrics.getAscent();
//      // Set the font
//      g.setFont(font);
//      // Draw the String
//      g.drawString(text, x, y);
//  }
  
  
  
  @Override
  public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
    super.paintBorder(c, g, x, y, width, height);
    Graphics2D g2d = (Graphics2D)g;
    //paintComplex(g2d, width, height);
    simplePolygon(g2d, width, height);
  }
  
  
  @Override
  public Insets getBorderInsets(Component c)       {
    return getBorderInsets(c, new Insets(gap, gap, gap, gap));
  }

  
  
  @Override
  public Insets getBorderInsets(Component c, Insets insets) {
      insets.left = gap;
      insets.top = gap; 
      insets.right = gap;
      insets.bottom = gap;
      return insets;
  }
}
