/**
 * The MIT License
 * Copyright © 2020 Thorsten Schulz <http://javacomm.net>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package net.javacomm.schulz;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;



/*****************************************************************************/
/*                                                                           */
/* Class       : JIncrementDecrementButtonPanel                              */
/* Owner       : Thorsten Schulz                                             */
/* License     : All rights reserved                                         */
/* Createtd    : 02.03.2004 by Thorsten Schulz, TSchulz@javacomm.net         */
/* Last Update : 17.04.2020 by Thorsten Schulz                               */
/*                                                                           */
/*****************************************************************************/

public class JIncrementDecrementButtonPanel extends JPanel implements PropertyChangeListener {

  /**
  * 
  */
  private static final long serialVersionUID = 1254610284390917410L;
  private EtchedBorder etched = new EtchedBorder(EtchedBorder.LOWERED);
  private JTextField text = new JTextField(5);
  private JArrowButtonPanel panel = new JArrowButtonPanel();
  private GridBagLayout gridbag = new GridBagLayout();
  private GridBagConstraints c = new GridBagConstraints();
  private int number = 0;
  private boolean max, min, ok;
  private int borderMin, borderMax;

  public JIncrementDecrementButtonPanel() {
    max = true;
    min = true;
    ok = false;
    borderMin = -5;
    borderMax = 18;
    text.setText("5");
    checkBorders();
    setLayout(gridbag);

    c.fill = GridBagConstraints.BOTH;
    gridbag.setConstraints(text, c);
    add(text);

    gridbag.setConstraints(panel, c);
    add(panel);
    panel.addJArrowPanelListener(this);

    setBorder(etched);
  }



  @Override
  public void propertyChange(PropertyChangeEvent event) {
    String str;

    str = event.getPropertyName();
    number = Functions.getNumber(text.getText());

    if (str.equals("down")) {
      System.out.println(ok);
      number--;
      if (min) {
        checkBorders();
        if (!ok) {
          number++;
          return;
        }
      }
      text.setText(String.valueOf(number));
    }
    else {
      System.out.println(ok);
      number++;
      if (max) {
        checkBorders();
        if (!ok) {
          number--;
          return;
        }
      }
      text.setText(String.valueOf(number));
    }
    return;
  }



  public void setMin(boolean min, int borderValue) {
    this.min = min;
    borderMin = borderValue;
    return;
  }



  public void setMax(boolean max, int borderValue) {
    this.max = max;
    borderMax = borderValue;
    return;
  }



  public void setDefaultValue(int value) {
    text.setText(String.valueOf(value));
    return;
  }



  public int getValue() {
    int x = 0;
    x = Functions.getNumber(text.getText());
    return (x);
  }



  private void checkBorders() {
    if (max & !min) {
      if (number - 1 >= borderMax) {
        ok = false;
      }
      else {
        ok = true;
      }
    }
    if (min & !max) {
      if (number + 1 <= borderMin) {
        ok = false;
      }
      else {
        ok = true;
      }
    }
    if (min & max) {
      if (number + 1 > borderMin & number - 1 < borderMax) {
        ok = true;
      }
      else {
        ok = false;
      }
    }
    if (!min & !max) {
      ok = true;
    }
    return;
  }

}