/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.database.entity;

import java.time.ZonedDateTime;



/**
 * Diese Klasse bildet die Tabelle TB_TELKO ab.
 *
 * @author lromero
 *
 */
public class Telko {

  private String konferenzraum;
  private String organisator;
  private ZonedDateTime until;
  private String texto;
  private byte[] screenshot;

  public String getKonferenzraum() {
    return konferenzraum;
  }



  public void setKonferenzraum(String telkoid) {
    this.konferenzraum = telkoid;
  }



  public String getOrganisator() {
    return organisator;
  }



  public void setOrganisator(String uid) {
    this.organisator = uid;
  }



  public ZonedDateTime getUntil() {
    return until;
  }



  public void setUntil(ZonedDateTime until) {
    this.until = until;
  }



  public String getTexto() {
    return texto;
  }



  public void setTexto(String texto) {
    this.texto = texto;
  }



  public byte[] getScreenshot() {
    return screenshot;
  }



  public void setScreenshot(byte[] screenshot) {
    this.screenshot = screenshot;
  }

}
