/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.database.entity;

public class Filetransfer {

  private String uid;
  private String file;
  private String filename;
  private long filesize;
  private String ip;
  private int port;
  private int number;

  public String getUid() {
    return uid;
  }



  public void setUid(String uid) {
    this.uid = uid;
  }



  public String getFile() {
    return file;
  }



  public void setFile(String file) {
    this.file = file;
  }



  public String getFilename() {
    return filename;
  }



  public void setFilename(String filename) {
    this.filename = filename;
  }



  public long getFilesize() {
    return filesize;
  }



  public void setFilesize(long filesize) {
    this.filesize = filesize;
  }



  public String getIp() {
    return ip;
  }



  public void setIp(String ip) {
    this.ip = ip;
  }



  public int getPort() {
    return port;
  }



  public void setPort(int port) {
    this.port = port;
  }



  public int getNumber() {
    return number;
  }



  public void setNumber(int number) {
    this.number = number;
  }

}
