/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.database.entity;

/**
 * 
 * Die Klasse bildet die Tabelle TB_CONFIG ab.
 * 
 * @author llange
 *
 */
public class Config {

  private String domain;
  private Boolean isPublic;
  private String mailSmtpUser;
  private String mailSmtpHost;
  private int mailSmtpPort;
  private int flipToForum = 150;
  private int hours;
  private int account;

  public Config() {}



  public String getDomain() {
    return domain;
  }



  public Boolean getIsPublic() {
    return isPublic;
  }



  public String getMailSmtpHost() {
    return mailSmtpHost;
  }



  public String getMailSmtpUser() {
    return mailSmtpUser;
  }



  public void setDomain(String domain) {
    this.domain = domain;
  }



  public void setIsPublic(Boolean isPublic) {
    this.isPublic = isPublic;
  }



  public void setMailSmtpHost(String mailSmtpHost) {
    this.mailSmtpHost = mailSmtpHost;
  }



  public void setMailSmtpUser(String mailSmtpUser) {
    this.mailSmtpUser = mailSmtpUser;
  }



  public int getMailSmtpPort() {
    return mailSmtpPort;
  }



  public void setMailSmtpPort(int mailSmtpPort) {
    this.mailSmtpPort = mailSmtpPort;
  }



  public int getFlipToForum() {
    return flipToForum;
  }



  public void setFlipToForum(int flipToForum) {
    this.flipToForum = flipToForum;
  }



  public int getHours() {
    return hours;
  }



  public void setHours(int hours) {
    this.hours = hours;
  }



  public int getAccount() {
    return account;
  }



  public void setAccount(int account) {
    this.account = account;
  }

}
