/**
 * Module descriptor added to enable Java Platform Module System (JPMS) support.
 *
 * Original library: jersey-server Copyright (c) 2024 Oracle and/or its
 * affiliates.
 *
 * This file was added by Luis Andrés Lange <https://javacomm.net>, 2025.
 *
 * Licensed under the Eclipse Public License v. 2.0 (EPL-2.0).
 *
 * This file does not modify or replace the licensing terms of the original
 * work.
 */
module org.glassfish.jersey.server {
  requires jakarta.annotation;
  requires java.logging;
  requires org.glassfish.jersey.client;

  requires transitive jakarta.inject;
  requires transitive jakarta.validation;
  requires transitive jakarta.ws.rs;
  requires transitive jakarta.xml.bind;
  requires transitive java.management;
  requires transitive java.xml;
  requires transitive org.glassfish.jersey.common;

  exports com.sun.research.ws.wadl;
  exports jersey.repackaged.org.objectweb.asm;
  exports org.glassfish.jersey.server;
  exports org.glassfish.jersey.server.filter;
  exports org.glassfish.jersey.server.filter.internal;
  exports org.glassfish.jersey.server.internal;
  exports org.glassfish.jersey.server.internal.inject;
  exports org.glassfish.jersey.server.internal.monitoring;
  exports org.glassfish.jersey.server.internal.monitoring.core;
  exports org.glassfish.jersey.server.internal.monitoring.jmx;
  exports org.glassfish.jersey.server.internal.process;
  exports org.glassfish.jersey.server.internal.routing;
  exports org.glassfish.jersey.server.internal.scanning;
  exports org.glassfish.jersey.server.internal.sonar;
  exports org.glassfish.jersey.server.model;
  exports org.glassfish.jersey.server.model.internal;
  exports org.glassfish.jersey.server.monitoring;
  exports org.glassfish.jersey.server.spi;
  exports org.glassfish.jersey.server.spi.internal;
  exports org.glassfish.jersey.server.wadl;
  exports org.glassfish.jersey.server.wadl.config;
  exports org.glassfish.jersey.server.wadl.internal;
  exports org.glassfish.jersey.server.wadl.internal.generators;
  exports org.glassfish.jersey.server.wadl.internal.generators.resourcedoc;
  exports org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.model;
  exports org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.xhtml;
  exports org.glassfish.jersey.server.wadl.processor;

  provides jakarta.ws.rs.ext.RuntimeDelegate with org.glassfish.jersey.server.internal.RuntimeDelegateImpl;
  provides org.glassfish.jersey.internal.spi.AutoDiscoverable
      with org.glassfish.jersey.server.filter.internal.ServerFiltersAutoDiscoverable;
  provides org.glassfish.jersey.internal.spi.ForcedAutoDiscoverable
      with org.glassfish.jersey.server.wadl.internal.WadlAutoDiscoverable,
      org.glassfish.jersey.server.internal.monitoring.MonitoringAutodiscoverable;
  provides org.glassfish.jersey.model.internal.spi.ParameterServiceProvider
      with org.glassfish.jersey.server.model.Parameter.ServerParameterService;

  uses jakarta.ws.rs.ext.RuntimeDelegate;
  uses org.glassfish.jersey.internal.spi.AutoDiscoverable;
  uses org.glassfish.jersey.internal.spi.ForcedAutoDiscoverable;
  uses org.glassfish.jersey.model.internal.spi.ParameterServiceProvider;

}
