/**
 * Module descriptor added to enable Java Platform Module System (JPMS) support.
 *
 * Original library: jersey-hk2 Copyright (c) 2024 Oracle and/or its affiliates.
 *
 * This file was added by Luis Andrés Lange <https://javacomm.net>, 2025.
 *
 * Licensed under the Eclipse Public License v. 2.0 (EPL-2.0).
 *
 * This file does not modify or replace the licensing terms of the original
 * work.
 */
module org.glassfish.jersey.inject.h2k {
  requires h2k.locator;
  requires jakarta.annotation;
  requires java.logging;
  requires org.glassfish.h2k.utils;

  requires transitive jakarta.inject;
  requires transitive jakarta.ws.rs;
  requires transitive org.glassfish.h2k.api;
  requires transitive org.glassfish.jersey.common;

  exports org.glassfish.jersey.inject.hk2;

  provides org.glassfish.jersey.innate.inject.spi.ExternalRegistrables
      with org.glassfish.jersey.inject.hk2.Hk2Registrables;
  provides org.glassfish.jersey.internal.inject.InjectionManagerFactory
      with org.glassfish.jersey.inject.hk2.Hk2InjectionManagerFactory;

  uses org.glassfish.jersey.innate.inject.spi.ExternalRegistrables;
  uses org.glassfish.jersey.internal.inject.InjectionManagerFactory;

  opens org.glassfish.jersey.inject.hk2 to org.glassfish.h2k.utils;

}
