/**
 *  Copyright © 2020-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.phone;

import net.javacomm.transfer.Sprachguete;



/**
 * Die verfügbaren Audioformate für eine Mikrofonaufnahme oder
 * Lautsprecherwiedergabe.
 * 
 * @author llange
 *
 */
public enum Telefonformat {


  // 1200 BufferSize passt immer

  LOW(Sprachguete.LOW, 8000, SampleSizeInBits.BITS16, Channels.STEREO, Encoding.PCM_SIGNED, Endian.LITTLE,
      1152),
  MEDIUM_LOW(Sprachguete.MEDIUM_LOW, 9600, SampleSizeInBits.BITS16, Channels.STEREO, Encoding.PCM_SIGNED,
      Endian.LITTLE, 1152),
  MEDIUM(Sprachguete.MEDIUM, 16000, SampleSizeInBits.BITS16, Channels.STEREO, Encoding.PCM_SIGNED,
      Endian.LITTLE, 1152),
  HIGH(Sprachguete.HIGH, 19200, SampleSizeInBits.BITS16, Channels.STEREO, Encoding.PCM_SIGNED, Endian.LITTLE,
      1152),
  SUPER_HIGH(Sprachguete.SUPER_HIGH, 44100, SampleSizeInBits.BITS16, Channels.STEREO, Encoding.PCM_SIGNED,
      Endian.LITTLE, 1152);
  
  

  private float frequenz;
  private SampleSizeInBits sampleSizeInBits;
  private Channels channels;
  private Encoding signed;
  private Endian endian;
  private Sprachguete sound;
  private int bufferSize;
  
  
  
  private Telefonformat(Sprachguete sound) {
    this.sound = sound;
  }
  
  

  private Telefonformat(Sprachguete sound,
                        float hz,
                        SampleSizeInBits sampleSizeInBits, 
                        Channels channels, 
                        Encoding signed, 
                        Endian endian,
                        int bufferSize) {
    
    this.sound = sound;
    frequenz = hz;
    this.sampleSizeInBits = sampleSizeInBits;
    this.channels = channels;
    this.signed = signed;
    this.endian = endian;
    this.bufferSize = bufferSize;
  }
  
  
  @Override
  public String toString() {
    return sound.toString();
  }
  

  
  public SampleSizeInBits getSampleSizeInBits() {
    return sampleSizeInBits;
  }
  
  
  /**
   * Einkanal oder Zweikanal?
   * 
   * 
   * @return Mono oder Stereo
   */
  public Channels channels() {
    return channels;
  }
  
  
  
  public Encoding encoding() {
    return signed;
  }
  
  
  
  public Endian endian() {
    return endian;
  }
  
  
  
  public float getFrequenz() {
    return frequenz;
  }
  
  
  
  /**
   * Die Datenpuffergröße für das vorliegende Telefonformat.
   * 
   * 
   * @return Puffergröße in Bytes
   */
  public int getBufferSize() {
    return bufferSize;
  }
  
  
  
}
