/**
 *  Copyright © 2020-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.mediaplayer;

import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import net.javacomm.client.resource.Resource;

public class JButtonMute extends JButton {

  private static final long serialVersionUID = -8285019386464350927L;
  private boolean speaker_on = true;
  private ImageIcon iconSelected;
  private ImageIcon iconNotSelected;
  
  public JButtonMute() {
    
    //Button Not Selected
    //--------------------
    Class<? extends JButtonMute> resource = getClass();
    URL urlNotSelected = resource.getResource(Resource.ICON_SPEAKER_ON);
    iconNotSelected = new ImageIcon(urlNotSelected);

    //Button Selected
    //--------------------
    URL urlSelected = resource.getResource(Resource.ICON_SPEAKER_OFF);
    iconSelected = new ImageIcon(urlSelected);
    
    changeSpeakerOn();
    
  }
  
  
  
  /**
   * Das Image für Speaker_on oder Speaker_off wird gesetzt.
   *
   *
   * @param value
   *              {@code true} ist Speaker_on bzw. Stummschaltung ist aktiviert
   */
  public boolean changeSpeakerOn() {
    speaker_on = !speaker_on;
    if (speaker_on) {
      setIcon(iconSelected);
    }
    else {
      setIcon(iconNotSelected);
    }
    return speaker_on;
  }


  /**
   * Ist der Lautsprecher an oder aus?
   *
   * @return {@code true} der Lautsprecher ist deaktiviert
   */
  public boolean isSpeakerOn() {
    return speaker_on;
  }
  
  
  
  

}
