/**
 *  Copyright © 2020-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.gui;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JSlider;
import javax.swing.plaf.synth.SynthSliderUI;



public class VideosliderUI extends SynthSliderUI {


  protected MouseMotionListener mouselistener;
  private Point mousePoint;
  private int timerPosition;
  
  
  protected VideosliderUI(JSlider slider) {
    super(slider);
    mouselistener = new MouseMotionListener() {

      @Override
      public void mouseDragged(MouseEvent e) {}

      @Override
      public void mouseMoved(MouseEvent event) {
//        if (trackRect!=null) {
//          log.info("trackHeight=" + trackRect.height);
//        }
//        if (contentRect!=null) {
//          log.info("contentHeight=" + contentRect.height);
//        }
//        if (thumbRect!=null) {
//          log.info("thumbRect.height=" + thumbRect.height);
//          log.info("thumbRect.y=" + thumbRect.y);
//        }
//        if (labelRect!=null) {
//          log.info("labelRect.height=" + labelRect.height);
//          log.info("labelRect.y=" + labelRect.y);
//        }
//        log.info("--");
        
        boolean xRange = (labelRect.x <= event.getPoint().x) && (event.getPoint().x <= (labelRect.x + trackRect.width));
        boolean yRange = thumbRect.y+1 <= event.getPoint().y  && (event.getPoint().y <= trackRect.height);
            
        if (xRange && yRange) {
          mousePoint = event.getPoint();
          timerPosition = mousePoint.x - labelRect.x;
        }
        else {
          timerPosition = Videoslider.OUTSIDE_TRACK;
        }
      }
    };
  }

  
  
  /**
   * Gib die aktuelle Timerposition in Pixel zurück.
   * 
   * @return Zeit in Pixel
   */
  protected int getTimerposition() {
    return timerPosition;
  }
  
  
  
  /**
   * Gib die maximale Zeit in Pixel zurück.
   * 
   * @return Zeit in Pixel
   */
  protected int getMaxTimevalue() {
    return trackRect.width;
  }
  
  
  
  /**
   * Die relative (x,y)-Mausposition in bezug zur auslösenden Komponente. Die
   * auslösende Komponente ist der Schieberegler als Ganzes.
   * 
   * @return (x,y)-Mausposition
   */
  protected Point getMousePoint() {
    return mousePoint;
  }
  
 
  
  
  @Override
  protected void uninstallListeners(JSlider slider) {
    super.uninstallListeners(slider);
    slider.removeMouseMotionListener(mouselistener);
  }
  
  
  @Override
  protected void installListeners(JSlider slider) {
    super.installListeners(slider);
    slider.addMouseMotionListener(mouselistener);
  }
  

  

}
