/**
 *  Copyright © 2020-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.administer;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.nexuswob.gui.InputDocument;
import net.javacomm.client.environment.GUI;
import net.javacomm.client.resource.Resource;
import net.javacomm.multilingual.Babelfish;
import net.javacomm.multilingual.MultilingualLabel;
import net.javacomm.multilingual.schema.ISO639;
import net.javacomm.multilingual.schema.KEY;
import net.javacomm.window.manager.Control;



class JRegistryPanel extends JPanel implements Babelfish {

//  private final static Logger log = LogManager.getLogger(JRegistryPanel.class);
  private static final long serialVersionUID = 6623648467675731386L;
  private MultilingualLabel labeleMail = new MultilingualLabel(KEY.STRING_MAIL);
  private JTextField texteMail = new JTextField();
  private InputDocument docMail = new InputDocument(64);
  private JScrollPane scrollpane = new JScrollPane();
  private JTextArea textarea = new JTextArea();

  private GridBagLayout gridbag = new GridBagLayout();
  private GridBagConstraints con = new GridBagConstraints();

  private PropertyChangeSupport changes = new PropertyChangeSupport(this);

  public JRegistryPanel(boolean isDoubleBuffer) {
    super(isDoubleBuffer);
    setLayout(gridbag);

    con.insets = new Insets(12, 12, 0, 6);
    con.gridy = 0;
    con.anchor = GridBagConstraints.WEST;
    gridbag.setConstraints(labeleMail, con);
    add(labeleMail);

    con.insets = new Insets(12, 0, 0, 12);
    con.weightx = 1.0;
    con.fill = GridBagConstraints.HORIZONTAL;
    gridbag.setConstraints(texteMail, con);
    add(texteMail);
    texteMail.setBackground(Resource.JQUERY_HELLBLAU);
    texteMail.setForeground(Resource.JQUERY_BLAU);
    texteMail.setDocument(docMail);
    texteMail.addKeyListener(new KeyListener() {

      @Override
      public void keyPressed(KeyEvent e) {}



      @Override
      public void keyReleased(KeyEvent event) {
        if (event.getKeyCode() == KeyEvent.VK_ENTER) {
          changes.firePropertyChange(JRegistryPanel.class.getName(), Control.NULL, Control.REGISTER);
          return;
        }
        if (texteMail.getText().length() >= 1) {
          if (textarea.getText().length() == 0) return;
          clear();
        }
      }



      @Override
      public void keyTyped(KeyEvent e) {}
    });

    con.gridy = 1;
    con.gridwidth = 2;
    con.insets = new Insets(12, 12, 12, 12);

    con.weighty = 1.0;
    con.anchor = GridBagConstraints.WEST;
    con.fill = GridBagConstraints.BOTH;
    gridbag.setConstraints(scrollpane, con);
    scrollpane.setViewportView(textarea);
    textarea.setLineWrap(true);
    textarea.setWrapStyleWord(true);
    // textarea.setDocument(new InputDocument(0));
    textarea.setEditable(false);
    textarea.setFont(GUI.semiFont15);
    clear();
    add(scrollpane);
  }



  public synchronized void addSignListener(PropertyChangeListener l) {
    changes.addPropertyChangeListener(l);
  }



  /**
   *
   * Der Nachrichtenbereich wird gelöscht.
   *
   */
  private void clear() {
    textarea.setText(new String());
    // TODO UIManager.standard
    setBackgroundTextArea(Resource.JQUERY_HELLBLAU);
  }



  public String getEmail() {
    return (texteMail.getText());
  }



  public synchronized void removeAllSignListener() {
    for (PropertyChangeListener listener : changes.getPropertyChangeListeners()) {
      removeSignListener(listener);
    }
  }



  public synchronized void removeSignListener(PropertyChangeListener l) {
    changes.removePropertyChangeListener(l);
  }



  public void setBackgroundTextArea(Color c) {
    textarea.setBackground(c);
  }



  public void setMessage(String str, Color c) {
    textarea.setText(str);
    textarea.setForeground(c);
  }



  public synchronized void setMessage(String str, Color foreground, Color background) {
    textarea.setText(str);
    textarea.setForeground(foreground);
    textarea.setBackground(background);
  }



  @Override
  public void setLanguage(ISO639 code) {
    labeleMail.setLanguage(KEY.STRING_MAIL, code);
  }

}
