create database if not exists olymp collate utf8mb4_general_ci;

use olymp;
# ROOMFILTER enthält alle verbotenen Namen
# FORBIDDEN muss vom selben Typ wie CHATID sein.

create table if not exists TB_ROOMFILTER (
  FORBIDDEN varchar(24) not null primary key
) character set utf8mb4 collate utf8mb4_general_ci engine=aria;



# Die Tabelle enthält alle Chaträume
# chatid ist der raumname
# die GROUPID leitet sich aus der CHATID ab. 
# owner=nickname
# UID = hatte den Raum angelegt
# ROOMTYPE = FORUM, BESPRECHUNGSRAUM, PAUSENRAUM, GRUPPENRAUM
create table if not exists TB_CHAT (
  CHATID varchar(24) not null primary key,
  GROUPID varchar(24) unique,
  LIFETIME int,
  ENTRY int,
  OWNER varchar(24),
  UID char(8),
  ROOMTYPE int,
  NACIMIENTO datetime,
  INDEX (LIFETIME),
  INDEX(ROOMTYPE),
  INDEX (UID),
  INDEX(ENTRY,CHATID),
  INDEX(OWNER,LIFETIME,ENTRY)
) character set utf8mb4 collate utf8mb4_general_ci engine=aria;


create table if not exists TB_GRUPPE_USER (
  GROUPID varchar(24) not null,
  UID char(8) not null,
  primary key (GROUPID,UID)
) character set utf8mb4 collate utf8mb4_general_ci engine=aria;


# In der Tabelle sind alle USER, die gerade online sind.
# SINCE der Anwender hat sich um diese Uhrzeit angemeldet
# KEEPALIVE ist eine Zeitscheibe und wird als Referenz für das Schließen der Clientverbindung herangezogen
# SINCE die Anmeldung erfolgte um diese Zeit
# AGENT gibt die Geräteklasse an, mit der sich der Anwender angemeldet hatte. 0=Desktop, 1=Browser, 2=Tablet, 3=SmartPhone
# ONBUSY true, er ist am telefonieren
# AES der Schlüssel ist Base64 codiert

create table if not exists TB_ONLINE (
  UID char(8) primary key,
  SESSION char(10) NOT NULL UNIQUE,
  AGENT int,
  ONBUSY tinyint(1),
  AES varchar(44) NOT NULL,
  KEEPALIVE datetime,
  SINCE datetime
) character set utf8mb4 collate utf8mb4_general_ci engine=memory;


# Speichert die Nachrichten eines Chatraumes ab
# NUMBER wird mit UUID_SHORT() generiert, Number ist ein Nachrichtenzähler für den Raum
create table if not exists TB_RECORD (
  CHATID varchar(24) not null,
  NUMBER bigint not null,
  UID char(8),
  ANLAGE bigint,
  TIME TIMESTAMP(6) DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6),
  MESSAGE varchar(255),
  primary key (CHATID,NUMBER)
) character set utf8mb4 collate utf8mb4_general_ci engine=aria;



# Die Tabelle enthält gängige Dateiformate.
create table if not exists TB_FILETYPES (
  SUFFIX varchar(8) not null primary key,
  DESCRIPTION varchar(80),
  CATEGORY varchar(16)
) character set utf8mb4 collate utf8mb4_general_ci engine=aria;


# Dateien mit den aufgeführten Endungen dürfen nicht hochgeladen werden.
create table if not exists TB_USER_BLACKLIST (
  UID char(8),
  SUFFIX varchar(8),
  DENY tinyint(1) default 0,
  primary key (UID,SUFFIX)
) character set utf8mb4 collate utf8mb4_general_ci engine=aria;


# STARTTYPE = 1 von Hand aus starten
# STARTTYPE = 2 automatisch starten
# PORT = auf diesem PORT horcht der Server
create table if not exists TB_FILETRANSFER_CONFIG (
  UID char(8) not null primary key,
  PORT int default 29467,
  STARTTYPE int default 1,
  DOWNLOADDIR varchar(255),
  UPLOADDIR varchar(255)
) character set utf8mb4 collate utf8mb4_general_ci engine=aria;



create table if not exists TB_FILETRANSFER (
  UID char(8) not null,
  FILE varchar(255) not null,
  FILENAME varchar(255) not null,
  FILESIZE bigint default 0,
  IP varchar(15) not null,
  PORT int unsigned NOT null,
  NUMBER int unsigned NOT NULL,
  index (UID),
  index(FILENAME),
  index(NUMBER),
  index(PORT)
) character set utf8mb4 collate utf8mb4_general_ci engine=aria;

# Nach einer erfolgreichen Anmeldung wird CONFIRM_PASSWORD immer auf 0=true gesetzt.
# CONFIRM_PASSWORD wird auf 1 gesetzt, wenn der Anwender ein neues PASSWORD anfordert.
# BENUTZERSTATUS; 1=Vollmitglied, 2=möchte Vollmitglied werden, 3=Vollmitgliedschaft bestätigt, 4=Mitgliedschaft abgelehnt
# VOLUME meint die Lautstärke [0..100] beim Telefonieren
# IPTVVOLUME meint die Lautstärke [0..100] beim Fernseher
# ONCALL Telefonate werden in der Grundeinstellung abgelehnt. ONCALL true, wenn der Anwender kontaktiert werden darf
# TELEFONPORT Standard=2=1200 Puffer
# CHATDENIED true=Chatanfragen werden generell abgelehnt
# Eis 1=Mokka, 2=Vanille, 3=Joghurt, 4=Blaubeere, 5=Erdbeere
# SPEAKER ist der Telefonlautsprecher
# MIKROFON ist das Telefonmikrofon
# ONREKORD der Empfang von Bildschirmdaten wird in der Grundeinstellung abgelehnt
# REKORDERPORT ist der Serverport vom Streamserver, gelöscht
# ONPROJEKTOR 1=true, wenn der Projektor in Betrieb ist
# LANGUAGE die gewählte Sprache im Frontend als ISO-639-1 Code de,en, es
# CHATTOOLTIP 0=false, Tooltipps weden angezeigt, Anzeige=Tooltipp ausblenden hat keinen Haken
# CHATDOWNLOADDIR das Downloadverzeichnis für den CHAT-FILE-TRANSFER
# CHATUPLOADDIR das Uploadverzeichnis für den CHAT-FILE-TRANSFER
# LDELETE 1=true das Benutzerkonto wurde logisch gelöscht
# TIME die letzte Anmeldung; die Zeit wird nur bei Vollmitgliedschaft gesetzt


create table if not exists TB_USER (
  UID char(8) not null primary key,
  MAIL varchar(64) not null unique,
  NICKNAME varchar(24) not null unique,
  BENUTZERSTATUS int,
  FOREGROUND int default -16777216,
  BACKGROUND int default -1,
  VOLUME int default 85,
  PLAYERVOLUME int default 68,
  IPTVVOLUME int default 68,
  ONCALL tinyint(1) default 0,
  TELEFONPUFFER int default 2,
  SPEAKER char(80),
  MIKROFON char(80),
  EIS int default 1,
  CHATDENIED tinyint(1) default 0,
  CHATTOOLTIP tinyint(1) default 0,
  CHATDOWNLOADDIR varchar(255),
  CHATUPLOADDIR varchar(255),
  ONREKORD tinyint(1) default 0,
  ONPROJEKTOR tinyint(1) default 0,
  PASSWORD char(60) not null,
  NEUES_PASSWORD char(60),
  CONFIRMATION_KEY varchar(16),
  CONFIRMATION_FLAG int DEFAULT 0,
  ISADMIN tinyint(1),
  LANGUAGE char(2) default 'de',
  LDELETE tinyint(1) default 0,
  TIME TIMESTAMP(6) DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6), 
  index(BENUTZERSTATUS),
  index(CONFIRMATION_FLAG)
) character set utf8mb4 collate utf8mb4_general_ci engine=aria;


# Die Tabelle enthält alle User, die aktuell in einem Chat sind.
create table if not exists TB_USER_CHAT (
  UID char(8) not null,
  CHATID varchar(24) not null,
  primary key (UID,CHATID)
) character set utf8mb4 collate utf8mb4_general_ci engine=aria;



#die folgende Tabelle ist für 1:1 Chats gedacht
create table if not exists TB_PRIVATE_CHAT (
    REMOTESESSION varchar(10),
    LOCALSESSION varchar(10),
    primary key(REMOTESESSION,LOCALSESSION)
) character set utf8mb4 collate utf8mb4_general_ci engine=aria;







# Bildschirmübertragung für die 1:1 Projektordarstellung
# Jeder Eintrag in der Tabelle ist eine aktuelle Sender-Empfänger-Verbindung.
create table if not exists TB_SCREENCAST (
    RECEIVERSESSION char(10) not null primary key,
    SENDERSESSION char(10)
) character set utf8mb4 collate utf8mb4_general_ci engine=memory;





# Wer telefoniert gerade mit wem?
# CALLER_UID = UID und RECEIVER_UID=UID
create table if not exists TB_TOPHONE (
  CALLER_UID char(8) not null,
  RECEIVER_UID char(8) not null,
  primary key(CALLER_UID, RECEIVER_UID)
) character set utf8mb4 collate utf8mb4_general_ci engine=memory;


# Ist die Domäne öffentlich oder privat?
# FLIPTOFORUM gibt die Minuten an, ab wann ein Pausenraum in ein Forum gewandelt wird
# HOURS nach wie vielen Stunden wird eine Nachricht in einem Chatraum gelöscht
# ACCOUNT nach wie vielen Tagen wird ein Konto wegen Inaktivität gelöscht
# RSA_PUBLIC 2048-Bit-Schlüssel ist nach X.509(Public Key) Base64 codiert
# RSA_PRIVATE 2048-Bit-Schlüssel ist nach PKCS#8(Private KEY) Base64 codiert

create table if not exists TB_CONFIG (
  DOMAIN varchar(253),
  ISPUBLIC tinyint(1),
  MAIL_SMTP_USER varchar(253),
  MAIL_SMTP_HOST varchar(253),
  MAIL_SMTP_PORT int,
  FLIPTOFORUM int default 150,
  HOURS int default 24,
  ACCOUNT int default 180,
  RSA_PUBLIC varchar(512),
  RSA_PRIVATE varchar(2048)
  
) character set utf8mb4 collate utf8mb4_general_ci engine=aria;


# Die Tabelle enthält alle veralteten Programmversionen.

create table if not exists TB_OUTDATED (
  PROGRAMMVERSION char(20) primary key
) character set utf8mb4 collate utf8mb4_general_ci engine=aria;

# Die Tabelle enthält alle verbotenen Nicknames.

create table if not exists TB_NICKNAMES (
  NICKNAME varchar(24) primary key
) character set utf8mb4 collate utf8mb4_general_ci engine=aria;


# Dateien, die über den Chat hochgeladen werden.
# ABSOLUTE ist der absolute Dateiname mit Pfadangabe
# MESSAGE ist not null, weil ein Anhang immer eine MESSAGE hat
# DELETABLE der Datensatz darf so lange nicht gelöscht werden, bis Phase_2 abgeschlossen ist.

create table if not exists TB_CHATFILE (
  ANLAGE bigint primary key,
  FILESIZE bigint default 0,
  DELETABLE tinyint(1) default 0,
  CHATID varchar(24) not null,
  ABSOLUTE varchar(255) not null,
  FILENAME varchar(255) not null,
  index(CHATID)
  
) character set utf8mb4 collate utf8mb4_general_ci engine=aria;


# Die übertragende Datei ist in mehrere Chunks gesplittet.

create table if not exists TB_CHATFILE_CHUNKS (
  ANLAGE bigint,
  CHUNK int unsigned NOT null,
  FILE blob,
  primary key(ANLAGE,CHUNK)
) character set utf8mb4 collate utf8mb4_general_ci engine=aria;


# Die übertragende Datei ist in mehrere Chunks gesplittet.
# Diese Tabelle speichert die angehängten Dateien, die zu einem Private Chat gehören.

create table if not exists TB_PRIVATE_CHATFILE_CHUNKS (
  ANLAGE bigint,
  CHUNK int unsigned NOT null,
  FILE blob,
  primary key(ANLAGE,CHUNK)
) character set utf8mb4 collate utf8mb4_general_ci engine=aria;



# Dateien, die über den Private Chat hochgeladen werden.
# UID der Absender
# ABSOLUTE ist der absolute Dateiname mit Pfadangabe
# NICKNAME ist der Raumname und der NICKNAME des Empfängers
# MESSAGE ist not null, weil ein Anhang immer eine MESSAGE hat
# ANLAGE ist der Referenzschlüssel für den Dateianhang; früher NUMBER

create table if not exists TB_PRIVATE_CHATFILE (
  ANLAGE bigint primary key,
  RECEIVER_UID char(8) not null,
  NICKNAME varchar(24),
  UID char(8) not null,
  FILESIZE bigint default 0,
  MESSAGE varchar(255) not null,
  ABSOLUTE varchar(255) not null,
  FILENAME varchar(255) not null,
  index(RECEIVER_UID)
  
) character set utf8mb4 collate utf8mb4_general_ci engine=aria;



# TB_TELKO verwaltet Videokonferenzen.
# KONFERENZRAUM der Konferenzname
# ORGANISATOR der ORGANISATOR hat die Telko eingerichtet und ist eine UID
# UNTIL bis wann soll der Schlüssel gültig sein
# TEXTO eine Kurzbeschreibung für die Telko

create table if not exists TB_TELKO (
  KONFERENZRAUM char(30),
  ORGANISATOR char(8) not null,
  UNTIL datetime,
  TEXTO varchar(255),
  primary key (KONFERENZRAUM,ORGANISATOR)
  
) character set utf8mb4 collate utf8mb4_general_ci engine=aria;

# MUTE ist das Mikrofon stumm? MUTE=0=false=ist nicht stumm; standardmäßig nicht stumm
# MUTE ist ein globales Attribut und bezieht sich auf alle Telkos, in denen der User sein kann,
# weil pro Rechner ein Mikro aufnimmt. MUTE gehört in die TB_USER.
# OFFHOOK ist der Anwender in der Konferenz? 0 = er ist nicht in der Konferenz und hat den Hörer aufgelegt
# UID ist der Konferenzteilnehmer; an diese Anwender werden Audiodaten gesendet
# Die Tabelle sagt aus, wer Teilnehmer in welcher Konferenz ist. Eine Konferenz hat viele Teilnehmer.

create table if not exists TB_KONFERENZRAUM (
  KONFERENZRAUM char(30) not null,
  ORGANISATOR char(8) not null,
  UID char(8) not null,
  OFFHOOK tinyint(1) default 0,
  MUTE tinyint(1) default 0,
  primary key (KONFERENZRAUM,ORGANISATOR,UID)
    
) character set utf8mb4 collate utf8mb4_general_ci engine=aria;


# Die Modulberechtigungen für die Anwender.
create table if not exists TB_USER_MODULE (
  UID char(8),
  MODULE int,
  primary key (UID,MODULE)
    
) character set utf8mb4 collate utf8mb4_general_ci engine=aria;


# Module 1=CHAT, 2=FILETRANSFER, 3=MEDIAPLAYER, 4=TELEFONIE, 5=BILDDCHIRMÜBERTRAGUNG, 7=IPTV
create table if not exists TB_MODULE (
  MODULE int,
  NAME varchar(32),
  primary key (MODULE)
    
) character set utf8mb4 collate utf8mb4_general_ci engine=aria;


# In TB_VIDEO werden die Sender und Empfänger von Bildschirmdaten eingetragen.
# Jeder Sender 1..n Empfänger
# SENDER ist eine UID
# RECEIVER ist eine UID

create table if not exists TB_VIDEO (
  SENDER char(8),
  RECEIVER char(8),
  primary key (SENDER, RECEIVER)
) character set utf8mb4 collate utf8mb4_general_ci engine=memory;

# Eine Bildschirmübertragung kann nur stattfinden, wenn der neue SENDER noch nicht in der Tabelle TB_VIDEO_SENDER steht.


# In dieser Tabelle werden die Screenshots einer Bildschirmübertragung gespeichert.
# SENDER ist eine UID

create table if not exists TB_VIDEO_SENDER (
  SENDER char(8),
  primary key (SENDER)
) character set utf8mb4 collate utf8mb4_general_ci engine=aria;


# TB_TOKEN enthält Einmal-Token.

create table if not exists TB_TOKEN (
  TOKEN char(36) NOT NULL
) character set utf8mb4 collate utf8mb4_general_ci engine=aria;

